<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Course extends Model 
{

    protected $table = 'courses';
    public $timestamps = true;

    public function modules()
    {
        return $this->hasMany('App\Models\Module');
    }

    public function questions()
    {
        return $this->hasMany('App\Models\SurveyQuestion');
    }

    public function duels()
    {
        return $this->hasMany('App\Models\Duel');
    }

    public function wallMessages()
    {
        return $this->hasMany('App\Models\WallMessages');
    }

    public function enrollments()
    {
        return $this->hasMany('App\Models\Enrollment');
    }

    public function problemsSummary()
    {
        return $this->belongsTo('App\Models\ModuleProblemUserSummary');
    }

    public function problemsAttempted()
    {
        return $this->hasMany('App\Models\Problem');
    }

    public function notifications()
    {
        return $this->hasMany('App\Models\Notification');
    }

}